import { MdkDtoBase } from "../MdkDtoBase.js";
import { PayNowIdParam } from "./PayNowIdParam.js";
import { AccountParam } from "./AccountParam.js";
import { ChargeParam } from "./ChargeParam.js";
import { AccountBasicParam } from "./AccountBasicParam.js";
import { CardParam } from "./CardParam.js";
import { RecurringChargeParam } from "./RecurringChargeParam.js";
import { BankAccountParam } from "./BankAccountParam.js";
import { OrderParam } from "./OrderParam.js";
import { PayNowIdConstants } from "./PayNowIdConstants.js";
export class AbstractPayNowIdRequestDto extends MdkDtoBase {
    constructor(serviceType) {
        super();
        this._serviceType = serviceType;
    }
    _serviceType;
    payNowIdParam;
    get accountId() {
        return this.payNowIdParam?.accountParam?.accountId;
    }
    set accountId(value) {
        this.existAccountParam().accountId = value;
    }
    get onetimeToken() {
        return this.payNowIdParam?.accountParam?.onetimeToken;
    }
    set onetimeToken(value) {
        this.existAccountParam().onetimeToken = value;
    }
    get onetimeTokenType() {
        return this.payNowIdParam?.accountParam?.onetimeTokenType;
    }
    set onetimeTokenType(value) {
        this.existAccountParam().onetimeTokenType = value;
    }
    get originalAccountId() {
        return this.payNowIdParam?.accountParam?.originalAccountId;
    }
    set originalAccountId(value) {
        this.existAccountParam().originalAccountId = value;
    }
    get payNowId() {
        return this.payNowIdParam?.accountParam?.payNowId;
    }
    set payNowId(value) {
        this.existAccountParam().payNowId = value;
    }
    get transData() {
        return this.payNowIdParam?.accountParam?.transData;
    }
    set transData(value) {
        this.existAccountParam().transData = value;
    }
    get createDate() {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.createDate;
    }
    set createDate(value) {
        this.existAccountBasicParam().createDate = value;
    }
    get deleteDate() {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.deleteDate;
    }
    set deleteDate(value) {
        this.existAccountBasicParam().deleteDate = value;
    }
    get forceDeleteDate() {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.forceDeleteDate;
    }
    set forceDeleteDate(value) {
        this.existAccountBasicParam().forceDeleteDate = value;
    }
    get deleteCardInfo() {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.deleteCardInfo;
    }
    set deleteCardInfo(value) {
        this.existAccountBasicParam().deleteCardInfo = value;
    }
    get addCardInfo() {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.addCardInfo;
    }
    set addCardInfo(value) {
        this.existAccountBasicParam().addCardInfo = value;
    }
    get deleteOriginalAccountId() {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.deleteOriginalAccountId;
    }
    set deleteOriginalAccountId(value) {
        this.existAccountBasicParam().deleteOriginalAccountId = value;
    }
    get defaultCardOnly() {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.defaultCardOnly;
    }
    set defaultCardOnly(value) {
        this.existAccountBasicParam().defaultCardOnly = value;
    }
    get cleaningConfig() {
        return this.payNowIdParam?.accountParam?.accountBasicParam?.cleaningConfig;
    }
    set cleaningConfig(value) {
        this.existAccountBasicParam().cleaningConfig = value;
    }
    get cardId() {
        return this?.payNowIdParam?.accountParam?.cardParam?.cardId;
    }
    set cardId(value) {
        this.existCardParam().cardId = value;
    }
    get defaultCard() {
        return this?.payNowIdParam?.accountParam?.cardParam?.defaultCard;
    }
    set defaultCard(value) {
        this.existCardParam().defaultCard = value;
    }
    get defaultCardId() {
        return this?.payNowIdParam?.accountParam?.cardParam?.defaultCardId;
    }
    set defaultCardId(value) {
        this.existCardParam().defaultCardId = value;
    }
    get updater() {
        return this?.payNowIdParam?.accountParam?.cardParam?.updater;
    }
    set updater(value) {
        this.existCardParam().updater = value;
    }
    get cardNumber() {
        return this?.payNowIdParam?.accountParam?.cardParam?.cardNumber;
    }
    set cardNumber(value) {
        this.existCardParam().cardNumber = value;
    }
    get cardExpire() {
        return this?.payNowIdParam?.accountParam?.cardParam?.cardExpire;
    }
    set cardExpire(value) {
        this.existCardParam().cardExpire = value;
    }
    get cardholderName() {
        return this?.payNowIdParam?.accountParam?.cardParam?.cardholderName;
    }
    set cardholderName(value) {
        this.existCardParam().cardholderName = value;
    }
    get token() {
        return this?.payNowIdParam?.accountParam?.cardParam?.token;
    }
    set token(value) {
        this.existCardParam().token = value;
    }
    get cardNumberMaskType() {
        return this.payNowIdParam?.accountParam?.cardParam?.cardNumberMaskType;
    }
    set cardNumberMaskType(value) {
        this.existCardParam().cardNumberMaskType = value;
    }
    get withAuthorize() {
        return this.payNowIdParam?.accountParam?.cardParam?.withAuthorize;
    }
    set withAuthorize(value) {
        this.existCardParam().withAuthorize = value;
    }
    get securityCode() {
        return this.payNowIdParam?.accountParam?.cardParam?.securityCode;
    }
    set securityCode(value) {
        this.existCardParam().securityCode = value;
    }
    get groupId() {
        let groupId = undefined;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            groupId = this.payNowIdParam?.accountParam?.recurringChargeParam?.groupId;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            groupId = this.payNowIdParam?.chargeParam?.groupId;
        }
        return groupId;
    }
    set groupId(value) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam().groupId = value;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam().groupId = value;
        }
    }
    get startDate() {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.startDate;
    }
    set startDate(value) {
        this.existRecurringChargeParam().startDate = value;
    }
    get endDate() {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.endDate;
    }
    set endDate(value) {
        this.existRecurringChargeParam().endDate = value;
    }
    get finalCharge() {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.finalCharge;
    }
    set finalCharge(value) {
        this.existRecurringChargeParam().finalCharge = value;
    }
    get recurringMemo1() {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.recurringMemo1;
    }
    set recurringMemo1(value) {
        this.existRecurringChargeParam().recurringMemo1 = value;
    }
    get recurringMemo2() {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.recurringMemo2;
    }
    set recurringMemo2(value) {
        this.existRecurringChargeParam().recurringMemo2 = value;
    }
    get recurringMemo3() {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.recurringMemo3;
    }
    set recurringMemo3(value) {
        this.existRecurringChargeParam().recurringMemo3 = value;
    }
    get useChargeOption() {
        return this.payNowIdParam?.accountParam?.recurringChargeParam?.useChargeOption;
    }
    set useChargeOption(value) {
        this.existRecurringChargeParam().useChargeOption = value;
    }
    get salesDay() {
        let salesDay = undefined;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            salesDay = this.payNowIdParam?.accountParam?.recurringChargeParam?.salesDay;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            salesDay = this.payNowIdParam?.chargeParam?.salesDay;
        }
        return salesDay;
    }
    set salesDay(value) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam().salesDay = value;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam().salesDay = value;
        }
    }
    get acquireCode() {
        let acquireCode = undefined;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            acquireCode = this.payNowIdParam?.accountParam?.recurringChargeParam?.acquireCode;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            acquireCode = this.payNowIdParam?.chargeParam?.acquireCode;
        }
        return acquireCode;
    }
    set acquireCode(value) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam().acquireCode = value;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam().acquireCode = value;
        }
    }
    get oneTimeAmount() {
        let oneTimeAmount = undefined;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            oneTimeAmount = this.payNowIdParam?.accountParam?.recurringChargeParam?.oneTimeAmount;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            oneTimeAmount = this.payNowIdParam?.chargeParam?.oneTimeAmount;
        }
        return oneTimeAmount;
    }
    set oneTimeAmount(value) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam().oneTimeAmount = value;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam().oneTimeAmount = value;
        }
    }
    get amount() {
        let amount = undefined;
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトから取得
            amount = this.payNowIdParam?.accountParam?.recurringChargeParam?.amount;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトから取得
            amount = this.payNowIdParam?.chargeParam?.amount;
        }
        return amount;
    }
    set amount(value) {
        if (this.isRecurring()) {
            // 会員課金情報オブジェクトに設定
            this.existRecurringChargeParam().amount = value;
        }
        else if (this.isCharge()) {
            // 課金グループ情報オブジェクトに設定
            this.existChargeParam().amount = value;
        }
    }
    get bankCode() {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.bankCode;
    }
    set bankCode(value) {
        this.existBankAccountParam().bankCode = value;
    }
    get branchCode() {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.branchCode;
    }
    set branchCode(value) {
        this.existBankAccountParam().branchCode = value;
    }
    get accountType() {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.accountType;
    }
    set accountType(value) {
        this.existBankAccountParam().accountType = value;
    }
    get accountNumber() {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.accountNumber;
    }
    set accountNumber(value) {
        this.existBankAccountParam().accountNumber = value;
    }
    get accountManageType() {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.accountManageType;
    }
    set accountManageType(value) {
        this.existBankAccountParam().accountManageType = value;
    }
    get rejectBankAccount() {
        return this.payNowIdParam?.accountParam?.bankAccountParam?.rejectBankAccount;
    }
    set rejectBankAccount(value) {
        this.existBankAccountParam().rejectBankAccount = value;
    }
    get groupName() {
        return this.payNowIdParam?.chargeParam?.groupName;
    }
    set groupName(value) {
        this.existChargeParam().groupName = value;
    }
    get type() {
        return this.payNowIdParam?.chargeParam?.type;
    }
    set type(value) {
        this.existChargeParam().type = value;
    }
    get chargeType() {
        return this.payNowIdParam?.chargeParam?.chargeType;
    }
    set chargeType(value) {
        this.existChargeParam().chargeType = value;
    }
    get schedule() {
        return this.payNowIdParam?.chargeParam?.schedule;
    }
    set schedule(value) {
        this.existChargeParam().schedule = value;
    }
    get tanking() {
        return this.payNowIdParam?.tanking;
    }
    set tanking(value) {
        this.existPayNowIdParam().tanking = value;
    }
    get originalOrderId() {
        return this.payNowIdParam?.orderParam?.originalOrderId;
    }
    set originalOrderId(value) {
        this.existOrderParam().originalOrderId = value;
    }
    get cleaningMerchantId() {
        return this.payNowIdParam?.orderParam?.cleaningMerchantId;
    }
    set cleaningMerchantId(value) {
        this.existOrderParam().cleaningMerchantId = value;
    }
    isRecurring() {
        return (PayNowIdConstants.SERVICE_TYPE_ACCOUNT == this._serviceType ||
            PayNowIdConstants.SERVICE_TYPE_RECURRING == this._serviceType);
    }
    isCharge() {
        return (PayNowIdConstants.SERVICE_TYPE_CHARGE == this._serviceType);
    }
    existPayNowIdParam() {
        if (this.payNowIdParam == null) {
            this.payNowIdParam = new PayNowIdParam();
        }
        return this.payNowIdParam;
    }
    existAccountParam() {
        const payNowIdParam = this.existPayNowIdParam();
        if (payNowIdParam?.accountParam == null) {
            payNowIdParam.accountParam = new AccountParam();
        }
        return payNowIdParam.accountParam;
    }
    existAccountBasicParam() {
        const accountParam = this.existAccountParam();
        if (accountParam.accountBasicParam == null) {
            accountParam.accountBasicParam = new AccountBasicParam();
        }
        return accountParam.accountBasicParam;
    }
    existCardParam() {
        const accountParam = this.existAccountParam();
        if (accountParam.cardParam == null) {
            accountParam.cardParam = new CardParam();
        }
        return accountParam.cardParam;
    }
    existRecurringChargeParam() {
        const accountParam = this.existAccountParam();
        if (accountParam.recurringChargeParam == null) {
            accountParam.recurringChargeParam = new RecurringChargeParam();
        }
        return accountParam.recurringChargeParam;
    }
    existChargeParam() {
        const payNowIdParam = this.existPayNowIdParam();
        if (payNowIdParam.chargeParam == null) {
            payNowIdParam.chargeParam = new ChargeParam();
        }
        return payNowIdParam.chargeParam;
    }
    existBankAccountParam() {
        const accountParam = this.existAccountParam();
        if (accountParam.bankAccountParam == null) {
            accountParam.bankAccountParam = new BankAccountParam();
        }
        return accountParam.bankAccountParam;
    }
    existOrderParam() {
        const payNowIdParam = this.existPayNowIdParam();
        if (payNowIdParam.orderParam == null) {
            payNowIdParam.orderParam = new OrderParam();
        }
        return payNowIdParam.orderParam;
    }
}
//# sourceMappingURL=AbstractPayNowIdRequestDto.js.map